/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5253;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.utils.Util;

public class GreyToSpriteTransformer
implements ISpriteTransformer {
    public static final class_2960 NAME = TConstruct.getResource("grey_to_sprite");
    public static final Deserializer DESERIALIZER = new Deserializer();
    private static final String TEXTURE_FOLDER = "textures";
    @Nullable
    private static AbstractSpriteReader READER = null;
    private static final List<SpriteMapping> MAPPINGS_TO_CLEAR = new ArrayList<SpriteMapping>();
    private final List<SpriteMapping> sprites;
    private final SpriteRange[] foundSpriteCache = new SpriteRange[256];
    private static final GreyToColorMapping.Interpolate<SpriteMapping, SpriteRange> SPRITE_RANGE = (first, second, grey) -> new SpriteRange((SpriteMapping)first, (SpriteMapping)second);
    private static final ToIntFunction<SpriteMapping> GET_GREY = SpriteMapping::getGrey;
    private static boolean init = false;

    private SpriteRange getSpriteRange(int grey) {
        if (this.foundSpriteCache[grey] == null) {
            this.foundSpriteCache[grey] = GreyToColorMapping.getNearestByGrey(this.sprites, GET_GREY, grey, SPRITE_RANGE);
        }
        return this.foundSpriteCache[grey];
    }

    private int getNewColor(int color, int x, int y) {
        if (class_5253.class_8045.method_48342((int)color) == 0) {
            return 0;
        }
        int grey = GreyToColorMapping.getGrey(color);
        int newColor = this.getSpriteRange(grey).getColor(x, y, grey);
        return GreyToColorMapping.scaleColor(color, newColor, grey);
    }

    @Override
    public void transform(class_1011 image) {
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                image.method_4305(x, y, this.getNewColor(image.method_4315(x, y), x, y));
            }
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        JsonArray colors = new JsonArray();
        for (SpriteMapping mapping : this.sprites) {
            JsonObject pair = new JsonObject();
            pair.addProperty("grey", (Number)mapping.grey);
            if (mapping.color != -1 || mapping.path == null) {
                pair.addProperty("color", String.format("%08X", Util.translateColorBGR(mapping.color)));
            }
            if (mapping.path != null) {
                pair.addProperty("path", mapping.path.toString());
            }
            colors.add((JsonElement)pair);
        }
        object.add("palette", (JsonElement)colors);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromBlack() {
        return GreyToSpriteTransformer.builder().addABGR(0, -16777216);
    }

    public static void init() {
        if (!init) {
            init = true;
            ISpriteTransformer.SERIALIZER.registerDeserializer(NAME, DESERIALIZER);
            MaterialPartTextureGenerator.registerCallback(GreyToSpriteTransformer::textureCallback);
        }
    }

    private static void textureCallback(@Nullable ExistingFileHelper existingFileHelper, @Nullable class_3300 manager) {
        if (READER != null) {
            MAPPINGS_TO_CLEAR.forEach(mapping -> {
                mapping.image = null;
            });
            MAPPINGS_TO_CLEAR.clear();
            READER.closeAll();
            READER = null;
        }
        if (existingFileHelper != null) {
            READER = new DataGenSpriteReader(existingFileHelper, TEXTURE_FOLDER);
        } else if (manager != null) {
            READER = new ResourceManagerSpriteReader(manager, TEXTURE_FOLDER);
        }
    }

    public GreyToSpriteTransformer(List<SpriteMapping> sprites) {
        this.sprites = sprites;
    }

    private record SpriteRange(@Nullable SpriteMapping before, @Nullable SpriteMapping after) {
        public int getColor(int x, int y, int grey) {
            if (this.before == null) {
                assert (this.after != null);
                return this.after.getColor(x, y);
            }
            if (this.after == null || this.before == this.after) {
                return this.before.getColor(x, y);
            }
            return GreyToColorMapping.interpolateColors(this.before.getColor(x, y), this.before.getGrey(), this.after.getColor(x, y), this.after.getGrey(), grey);
        }
    }

    private static class SpriteMapping {
        private final int grey;
        private final int color;
        @Nullable
        private final class_2960 path;
        private transient class_1011 image = null;

        @Nullable
        private class_1011 getImage() {
            if (this.path != null && this.image == null) {
                if (READER == null) {
                    throw new IllegalStateException("Cannot get image for a sprite without reader");
                }
                try {
                    this.image = READER.read(this.path);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to load required image", ex);
                }
                MAPPINGS_TO_CLEAR.add(this);
            }
            return this.image;
        }

        public int getColor(int x, int y) {
            class_1011 image;
            if (this.path != null && (image = this.getImage()) != null) {
                int spriteColor = image.method_4315(x % image.method_4307(), y % image.method_4323());
                if (this.color != -1) {
                    spriteColor = GreyToColorMapping.scaleColor(spriteColor, this.color, 255);
                }
                return spriteColor;
            }
            return this.color;
        }

        private SpriteMapping(int grey, int color, @Nullable class_2960 path) {
            this.grey = grey;
            this.color = color;
            this.path = path;
        }

        public int getGrey() {
            return this.grey;
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<SpriteMapping> builder = ImmutableList.builder();
        private int lastGrey = -1;

        private void checkGrey(int grey) {
            if (grey < 0 || grey > 255) {
                throw new IllegalArgumentException("Invalid grey value, must be between 0 and 255, inclusive");
            }
            if (grey <= this.lastGrey) {
                throw new IllegalArgumentException("Grey value must be greater than the previous value");
            }
            this.lastGrey = grey;
        }

        public Builder addABGR(int grey, int color) {
            this.checkGrey(grey);
            this.builder.add((Object)new SpriteMapping(grey, color, null));
            return this;
        }

        public Builder addARGB(int grey, int color) {
            return this.addABGR(grey, Util.translateColorBGR(color));
        }

        public Builder addTexture(int grey, class_2960 texture, int tint) {
            this.checkGrey(grey);
            this.builder.add((Object)new SpriteMapping(grey, Util.translateColorBGR(tint), texture));
            return this;
        }

        public Builder addTexture(int grey, class_2960 texture) {
            return this.addTexture(grey, texture, -1);
        }

        public GreyToSpriteTransformer build() {
            ImmutableList list = this.builder.build();
            if (list.size() < 2) {
                throw new IllegalStateException("Too few colors in palette, must have at least 2");
            }
            return new GreyToSpriteTransformer((List<SpriteMapping>)list);
        }
    }

    protected static class Deserializer
    implements JsonDeserializer<GreyToSpriteTransformer> {
        protected Deserializer() {
        }

        public GreyToSpriteTransformer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            JsonArray palette = class_3518.method_15261((JsonObject)object, (String)"palette");
            Builder paletteBuilder = GreyToSpriteTransformer.builder();
            for (int i = 0; i < palette.size(); ++i) {
                JsonObject palettePair = class_3518.method_15295((JsonElement)palette.get(i), (String)("palette[" + i + "]"));
                int grey = class_3518.method_15260((JsonObject)palettePair, (String)"grey");
                if (i == 0 && grey != 0) {
                    paletteBuilder.addABGR(0, -16777216);
                }
                int color = -1;
                if (palettePair.has("color")) {
                    color = JsonHelper.parseColor(class_3518.method_15265((JsonObject)palettePair, (String)"color"));
                }
                if (palettePair.has("path")) {
                    paletteBuilder.addTexture(grey, JsonHelper.getResourceLocation(palettePair, "path"), color);
                    continue;
                }
                paletteBuilder.addARGB(grey, color);
            }
            return paletteBuilder.build();
        }
    }
}

